package com.hp.controller;

import java.io.IOException;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.ht.bo.ApplicationUtil;
import com.ht.bo.KanglaEbookBO;
import com.ht.utility.CommonUtility;
import com.ht.vo.Product;

/**
 * Servlet implementation class KBController
 */
@WebServlet("/KBController")
public class KBController extends HttpServlet {
	private static final long serialVersionUID = 1L;

    /**
     * Default constructor. 
     */
    public KBController() {
        // TODO Auto-generated constructor stub
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		 KanglaEbookBO bo = new KanglaEbookBO();
		// ApplicationUtil util = new ApplicationUtil();
		 
		 request.setAttribute("catalog", bo.findAllCatalog());
		 //HttpSession session = util.createSession(request);
		 
		 String cat = request.getParameter("cat");
		 if( cat != null) {
			 List<Product> bookList =	bo.findAllBooksBySubCatalog("product::"+ cat.trim()+"::productList");
			 request.setAttribute("bookList", bookList);
		 }
		 
		 CommonUtility.sendtoAnotherPage(request, response, "/index.jsp");
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
	}
   
}
